#include <TFT_eSPI.h>
#include <CST816S.h>
#include "Free_Fonts.h"
#include <Wire.h>
#include <TimeLib.h>  // Add Time library for real-time clock functionality

//////////
#include <GSMSimCall.h>
// Initialize a HardwareSerial instance
HardwareSerial GSMSerial(1);
#define RESET_PIN 10 // you can use any pin.
static volatile int num = 0;
GSMSimCall call(GSMSerial, RESET_PIN); // GSMSimCall inherits from GSMSim. You can use GSMSim methods with it.

////////
TFT_eSPI tft = TFT_eSPI();
CST816S touch(5, 6, 10, 7);

unsigned long callStartTime = 0;
bool isCallActive = false;
bool onInitialScreen = true; // Flag to track the initial screen


String signalQuality = "";
String operatorName = "";

void setup() {
  Serial.begin(115200);
	GSMSerial.begin(115200, SERIAL_8N1, 44, 43); // RX on pin 44, TX on pin 43
	delay(1000);

  pinMode(TFT_BL, OUTPUT);
  digitalWrite(TFT_BL, HIGH);

  tft.begin();
  tft.fillScreen(TFT_BLACK);
  tft.setTextColor(TFT_WHITE, TFT_BLACK);
  tft.setFreeFont(FSB9);

  touch.begin();
  displayInitialScreen(); // Display the initial screen
}

void loop() {
  if (onInitialScreen) {
    // Transition to incoming call screen after a delay (e.g., 3 seconds)
    delay(4000);  // 3-second delay
    onInitialScreen = false;
    tft.fillScreen(TFT_BLACK); // Clear the screen
    drawPhoneNumber();
    drawButtons(false);  // First screen: Both buttons
  }

  if (touch.available()) {
    int x = touch.data.x;
    int y = touch.data.y;

    if (isCallButtonTouched(x, y) && !isCallActive) {  // Start call if not active
      Serial.println("Call button pressed");
      startCall();
    }

    if (isEndButtonTouched(x, y) && isCallActive) {  // End call only if active
      Serial.println("End button pressed");
      endCall();
    }
  }

  if (isCallActive) {
    updateCallTimer();
  }
}

void displayInitialScreen() {
   
  // Draw the time in the center of the screen
  setTime(10, 30, 0, 1, 1, 2024); // Set a fixed time for demonstration; adjust as needed
  char timeString[9];
  sprintf(timeString, "%02d:%02d:%02d", hour(), minute(), second());

  int centerX = 120;  // Center of the round display (240x240)
  int centerY = 120;
  signalQuality= (String(call.signalQuality()) );
  tft.setCursor(centerX - 40, centerY - 10);  // Center text
  tft.setTextColor(TFT_WHITE, TFT_BLACK);
  tft.setFreeFont(FSB9);
  tft.print(timeString);

  // Draw battery percentage within the circular display
  int batteryX = 10;
  int batteryY = 180; // Moved lower to fit within circular edge
  int batteryWidth = 50;
  int batteryHeight = 10;
  int batteryCharge = 75; // Example battery percentage
  tft.drawRect(batteryX, batteryY, batteryWidth, batteryHeight, TFT_WHITE);
  tft.fillRect(batteryX + 1, batteryY + 1, (batteryWidth - 2) * batteryCharge / 100, batteryHeight - 2, TFT_GREEN);

  // Draw network signal strength within the circular display
  int signalX = 180;
  int signalY = 180; // Moved lower to fit within circular edge
  int signalWidth = 8;
  int signalHeight = 10;
  int signalBars = 3; // Example signal strength

  for (int i = 0; i < signalBars; i++) {
    tft.fillRect(signalX, signalY + (signalHeight - (i + 1) * 2), signalWidth, (i + 1) * 2, TFT_WHITE);
    signalX -= signalWidth + 2; // Space between bars
  }
}

void drawPhoneNumber() {
  tft.setCursor(30, 50);
  tft.setTextColor(TFT_GREEN, TFT_BLACK);
  tft.print("706-135-0809");  // Display the phone number
}

void drawButtons(bool duringCall) {
  int buttonRadius = 30;

  if (!duringCall) {
    // Draw Answer Button (Green)
    int callButtonX = 80;
    int callButtonY = 180; // Adjust the position
    tft.fillCircle(callButtonX, callButtonY, buttonRadius, TFT_GREEN);
    tft.setTextColor(TFT_WHITE, TFT_GREEN);
    tft.setCursor(callButtonX - 20, callButtonY - 7); // Center text inside the circle
    tft.print("Answer");
  }

  // Draw End Button (Red)
  int endButtonX = duringCall ? 120 : 160; // Center in second screen
  int endButtonY = 180; // Adjust the position
  tft.fillCircle(endButtonX, endButtonY, buttonRadius, TFT_RED);
  tft.setTextColor(TFT_WHITE, TFT_RED);
  tft.setCursor(endButtonX - 10, endButtonY - 7); // Center text inside the circle
  tft.print("End");
}

bool isCallButtonTouched(int x, int y) {
  int buttonRadius = 30;
  int buttonX = 80;
  int buttonY = 180; // Same as callButtonY in drawButtons

  int dx = x - buttonX;
  int dy = y - buttonY;
  return (dx * dx + dy * dy <= buttonRadius * buttonRadius);
  call.answer();
}

bool isEndButtonTouched(int x, int y) {
  int buttonRadius = 30;
  int buttonX = isCallActive ? 120 : 160; // Center for second screen
  int buttonY = 180; // Same as endButtonY in drawButtons

  int dx = x - buttonX;
  int dy = y - buttonY;
  return (dx * dx + dy * dy <= buttonRadius * buttonRadius);
  call.hangoff();
}

void startCall() {
  isCallActive = true;
  callStartTime = millis();
  tft.fillScreen(TFT_BLACK); // Clear the screen

  // Display "Call in Progress" text
  tft.setCursor(30, 50);
  tft.setTextColor(TFT_GREEN, TFT_BLACK);
  tft.print("Call in progress...");

  drawButtons(true);  // Only show the red "End" button during the call
}

void endCall() {
  isCallActive = false;
  tft.fillScreen(TFT_BLACK); // Clear the screen

  // Display "Call Ended" text
  tft.setCursor(30, 50);
  tft.setTextColor(TFT_RED, TFT_BLACK);
  tft.print("Call Ended.");

  drawButtons(false);  // Reset to show both buttons for next call

  // Delay before switching back to the initial screen

  tft.fillScreen(TFT_BLACK); // Clear the screen
  displayInitialScreen(); // Show the initial screen again
}

void updateCallTimer() {
  unsigned long elapsedTime = millis() - callStartTime;
  unsigned int seconds = (elapsedTime / 1000) % 60;
  unsigned int minutes = (elapsedTime / 60000) % 60;
  unsigned int hours = (elapsedTime / 3600000);

  // Format time as HH:MM:SS
  char timeString[9];
  sprintf(timeString, "%02d:%02d:%02d", hours, minutes, seconds);

  tft.setCursor(30, 100);
  tft.setTextColor(TFT_GREEN, TFT_BLACK);
  tft.fillRect(30, 100, 200, 20, TFT_BLACK); // Clear the old time
  tft.print(timeString);
}
